/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Rendering;

import BryceImages.Operations.ImageFactory;
import BryceImages.Rendering.ColorCalculator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public abstract class DynamicColorCalculator
extends ColorCalculator {
    double x_scale = 1.0;
    double y_scale = 1.0;
    protected double x_pos = 0.0;
    protected double y_pos = 0.0;
    protected Color C_BACKGROUND = Color.WHITE;

    public DynamicColorCalculator(Dimension dim) {
        super(dim);
    }

    public DynamicColorCalculator(int w, int h) {
        super(w, h);
    }

    public DynamicColorCalculator(double x, double y, double scale_x, double scale_y, Dimension dim) {
        super(dim);
        this.x_scale = scale_x;
        this.y_scale = scale_y;
        this.check_scale_legality();
        this.x_pos = x;
        this.y_pos = y;
    }

    public DynamicColorCalculator(double x, double y, double scale_x, double scale_y, int width, int height) {
        super(width, height);
        this.x_scale = scale_x;
        this.y_scale = scale_y;
        this.check_scale_legality();
        this.x_pos = x;
        this.y_pos = y;
    }

    @Override
    public Color getColor(double x, double y) {
        double final_x = (x - (double)this.room_width / 2.0) / this.x_scale + this.x_pos;
        double final_y = (y - (double)this.room_height / 2.0) / this.y_scale + this.y_pos;
        return this.getRawColor(final_x, final_y);
    }

    public abstract Color getRawColor(double var1, double var3);

    public void incX() {
        this.incX(1);
    }

    public void incY() {
        this.incY(1);
    }

    public void incX(int pixels) {
        this.x_pos += this.x_scale * (double)pixels;
    }

    public void incY(int pixels) {
        this.y_pos += this.x_scale * (double)pixels;
    }

    public void setScale(double x, double y) {
        this.x_scale = x;
        this.y_scale = y;
        this.check_scale_legality();
    }

    private void check_scale_legality() {
        if (this.x_scale == 0.0 || this.y_scale == 0.0) {
            throw new Error("Error : Cannot have scales of 0, they are degenerate");
        }
    }

    public BufferedImage getRow(double row) {
        BufferedImage output = this.blankRow();
        int x = 0;
        while (x < this.room_width) {
            output.setRGB(x, 0, this.getColor(x, row).getRGB());
            ++x;
        }
        return output;
    }

    public BufferedImage getCol(double col) {
        BufferedImage output = this.blankCol();
        int y = 0;
        while (y < this.room_height) {
            output.setRGB(y, 0, this.getColor(col, y).getRGB());
            ++y;
        }
        return output;
    }

    protected BufferedImage blankCol() {
        return ImageFactory.ColorRect(this.C_BACKGROUND, 1, this.room_height);
    }

    protected BufferedImage blankRow() {
        return ImageFactory.ColorRect(this.C_BACKGROUND, this.room_width, 1);
    }
}

